/*
=======================================================================================
'Nível Classificação.: INFORMAÇÃO RESTRITA
'Versão..............: 202111231400
'Job.................:  
'Nome................: addcolumn 
'Objetivo............: Inserção/Atualização de novo campo na tabela;
'Tabelas.............: EST_ORC
'Dt Criação..........: 23/11/2021
'Dt Ult Alteracão....: --
'Criado por..........: Estevan Aquiles Pazzetti
'Alterado por........: --
'=======================================================================================
Ajuste de campo na tabela EST_ORC para atualização de tamanho do campo de endereço de   entrega (ENDR_ENTG);
*/

create or replace function addcolumn()
returns void as
$body$
begin

	IF EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'est_orc' AND COLUMN_NAME = 'endr_entg') THEN
		ALTER TABLE EST_ORC ALTER COLUMN endr_entg SET DATA TYPE varchar(150);
		RAISE NOTICE 'Coluna ENDR_ENTG alterado com sucesso!';		
	END IF;
	
	IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'est_orc' AND COLUMN_NAME = 'endr_entg') THEN
		ALTER TABLE EST_ORC ADD COLUMN endr_entg varchar(150);
		COMMENT ON COLUMN public.EST_ORC.endr_entg IS 'Campo utilizado para informação de endereço de entrega do cliente';
		RAISE NOTICE 'Coluna ENDR_ENTG adicionada com sucesso!';
	ELSE
		RAISE NOTICE 'A coluna ENDR_ENTG já existe na tabela PRC_FILIAL.';
	END IF;
end; 
$body$
language plpgsql volatile
  cost 100;
alter function addcolumn()  owner to postgres;
select addcolumn();
drop function addcolumn();